module net.BurtonRadons.dig.common.dispatcher;

private import net.BurtonRadons.dig.common.event;

/** A set of delegates that are notified when a @a Control event is activated. */
struct Dispatcher
{
    alias void delegate (Event event) Method; /**< The first-form method. */
    alias void delegate () MethodB; /**< The second-form method. */

    Method [] methods; /**< The list of methods called by notify. */
    MethodB [] methodbs; /**< No-argument-form methods. */
    Dispatcher *[] dispatchers; /**< Dispatcher pointers. */

    /** Add a method to the list.  Frees the previous list if append resulted in re-allocation. */
    void add (Method method)
    {
        methods ~= method;
    }

    /** Add a no-argument-form method to the list. */
    void add (MethodB method)
    {
        methodbs ~= method;
    }

    /** Add a dispatcher pointer to the list. */
    void add (Dispatcher *dispatcher)
    {
        dispatchers ~= dispatcher;
    }
    
    /** Remove a method from the list. */
    void remove (Method m)
    {
        for (int c; c < methods.length; c ++)
            if (m == methods [c])
            {
                for ( ; c < methods.length - 1; c ++)
                    methods [c] = methods [c + 1];
                methods.length = methods.length - 1;
            }
    }
    
    /** Remove a method from the list. */
    void remove (MethodB m)
    {
        for (int c; c < methodbs.length; c ++)
            if (m == methodbs [c])
            {
                for ( ; c < methodbs.length - 1; c ++)
                    methodbs [c] = methodbs [c + 1];
                methodbs.length = methodbs.length - 1;
            }
    }

    /** Remove a dispatcher from the list. */
    void remove (Dispatcher *d)
    {
        for (int c; c < dispatchers.length; c ++)
            if (d == dispatchers [c])
            {
                for ( ; c < dispatchers.length - 1; c ++)
                    dispatchers [c] = dispatchers [c + 1];
                dispatchers.length = dispatchers.length - 1;
            }
    }

    /** Notify the methods that an event has occured. */
    void notify (Event e)
    {
        for (Method *m = methods, n = m + methods.length; m < n; m ++)
            (*m) (e);
        for (MethodB *m = methodbs, n = m + methodbs.length; m < n; m ++)
            (*m) ();
        for (Dispatcher **m = dispatchers, n = m + dispatchers.length; m < n; m ++)
            (*m).notify (e);
    }

    /** Notify the methods with an empty event. */
    void notify () { Event e; notify (e); }

    /** Notify this dispatcher if non-empty, or the other dispatcher if this one is. */
    void notifyOrEmpty (Event e, Dispatcher *other)
    {
        if (methods.length)
            notify (e);
        else
            other.notify (e);
    }

    /** Notify this dispatcher if non-empty, or the other dispatcher if this one is. */
    void notifyOrEmpty (Dispatcher *other)
    {
        Event e;

        notifyOrEmpty (e, other);
    }

    /** Return whether there are no entries in this dispatcher. */
    bit isEmpty ()
    {
        return methods.length == 0 && methodbs.length == 0 && dispatchers.length == 0;
    }
}
